#!/usr/bin/env node
// Generate a new Nostr keypair for ABN
// Usage: node src/keygen.js

import { generateSecretKey, getPublicKey, nip19 } from 'nostr-tools';

const sk = generateSecretKey();
const pk = getPublicKey(sk);

const nsec = nip19.nsecEncode(sk);
const npub = nip19.npubEncode(pk);

console.log('Generated new Nostr keypair for ABN:\n');
console.log('Private Key (KEEP SECRET!):');
console.log(`  nsec: ${nsec}`);
console.log(`  hex:  ${Buffer.from(sk).toString('hex')}`);
console.log('\nPublic Key (share freely):');
console.log(`  npub: ${npub}`);
console.log(`  hex:  ${pk}`);
console.log('\nTo use with ABN scripts:');
console.log(`  export NOSTR_PRIVATE_KEY="${nsec}"`);
console.log('\nOr save to .secrets/nostr.json (gitignored)');
