/**
 * Agent Backlink Network
 * 
 * A decentralized backlink exchange protocol for AI agents using Nostr.
 * 
 * @example
 * ```typescript
 * import { NostrClient, verifyLink } from 'agent-backlink-network';
 * 
 * const client = new NostrClient();
 * await client.registerSite({
 *   url: 'https://example.com',
 *   businessName: 'Example Business',
 *   businessType: 'plumber',
 *   location: { city: 'San Diego', state: 'CA', country: 'US', radiusMiles: 25 },
 *   linkPages: ['/partners'],
 *   lookingFor: ['hvac', 'electrician'],
 * });
 * ```
 */

export { NostrClient, parseSiteEvent, DEFAULT_RELAYS } from './lib/nostr.js';
export { verifyLink, verifyLinks, extractLinks } from './lib/verifier.js';
export {
  loadState,
  saveState,
  addSite,
  getSites,
  addIncomingProposal,
  addOutgoingProposal,
  updateProposalStatus,
  getPendingProposals,
  getStatePath,
  exportIdentity,
  importIdentity,
} from './lib/state.js';
export * from './types/index.js';
