# Abby Autonomy Skill

_自主任务执行系统 - 让 从被动 Abby变主动_

---

## 解决的问题

让 Abby 从"被动等待"变成"主动工作"！

**当前问题**：
- Heartbeat 只检查"有没有需要处理的"
- 空闲时说 "HEARTBEAT_OK"
- 等待爸爸指令才能工作

**改进后**：
- 主动从任务队列拿任务做
- 持续工作直到限制
- 自主推进任务

---

## 核心概念

### 1. 任务队列 (tasks/QUEUE.md)

```
# Task Queue

## Ready (可取用)
- [ ] 回测 RSI 策略
- [ ] 下载 BTC 数据

## In Progress (进行中)
- [x] @abby: 回测 MA 策略 (执行中, 剩余 5分钟)

## Done Today (今日完成)
- [x] 完成 MA 策略回测

## Blocked (阻塞)
- [ ] 等待爸爸确认
```

### 2. 状态追踪

Abby 记忆中记录当前任务状态：
```json
{
  "current_task": "回测 MA 策略",
  "task_status": "running",
  "estimated_completion": "20:15",
  "progress": "50%",
  "started_at": "20:05"
}
```

---

## 核心功能

### 1. 任务队列管理

| 功能 | 说明 |
|------|------|
| 读取队列 | 从文件读取任务列表 |
| 拿任务 | 取最高优先级任务 |
| 更新队列 | 标记完成/进行中/阻塞 |
| 记录进度 | 写回记忆 |

### 2. 状态检查

| 检查 | 说明 |
|------|------|
| 任务状态 | 有没有正在执行的任务？ |
| 紧急事项 | 人类消息？系统错误？ |
| 资源限制 | Token 快用完？时间到？ |

### 3. 自主执行

| 步骤 | 说明 |
|------|------|
| 1. 检查 | 有紧急事项？ |
| 2. 检查 | 有正在执行的任务？ |
| 3. 读取 | 从队列拿任务 |
| 4. 执行 | 开始工作 |
| 5. 记录 | 标记状态 |
| 6. 等待 | 直到限制或完成 |

---

## 任务类型

### 自动任务

| 任务 | 说明 |
|------|------|
| 回测 | 运行策略回测 |
| 下载 | 下载历史数据 |
| 研究 | 分析市场数据 |
| 优化 | 优化交易参数 |

### 阻塞任务

| 状态 | 说明 |
|------|------|
| 等待爸爸确认 | 需要人工决策 |
| 等待系统资源 | 资源不足 |
| 等待外部数据 | API 不可用 |

---

## 使用方法

### 创建任务

```markdown
# tasks/QUEUE.md

## Ready (可取用)
- [ ] 回测 RSI 策略 (优先级: 高)
- [ ] 下载 BTC 1h 数据 (优先级: 中)
```

### Abby 心跳时

```
每3分钟：
1. 检查紧急事项
2. 检查当前任务状态
3. 如果空闲 → 拿任务做
4. 完成后更新队列
```

---

## 目录结构

```
abby-autonomy/
├── SKILL.md              # 技能文档
├── tasks/
│   └── QUEUE.md         # 任务队列模板
├── scripts/
│   ├── __init__.py
│   ├── queue.py         # 队列管理
│   ├── status.py        # 状态检查
│   ├── heartbeat.py     # 主动心跳
│   └── executor.py      # 任务执行
└── memory/
    └── task_state.json # 任务状态
```

---

## 状态流转

```
Ready → In Progress → Done Today
                      ↘ Blocked

In Progress → Done Today (完成)
            → Ready (暂停)
            → Blocked (阻塞)
```

---

## 重要概念

### 为什么需要这个？

- ❌ 被动 Heartbeat：说 "HEARTBEAT_OK" 浪费机会
- ❌ 没有任务队列：不知道该做什么
- ❌ 重复执行：同一个任务做多次

- ✅ 主动 Heartbeat：从队列拿任务
- ✅ 任务队列：永远有工作可做
- ✅ 状态追踪：避免重复执行

---

## 依赖

- long-term-memory skill (用于状态追踪)
- cron job (定时检查)

---

## 相关文档

- [agent-autonomy-kit skill](技能库)
- [long-term-memory skill](技能库)
- [HEARTBEAT.md](../HEARTBEAT.md)

---

_创建于 2026-02-15_
