# ClawMart Listing: A/B Test Architect

**Product type:** skill
**Price:** $19
**Category:** Marketing

**Name:** A/B Test Architect

**Tagline:** Plan, prioritize, and ship rigorous A/B tests — no guesswork, no wasted sprints.

**About:**
Most CRO programs fail not because tests lose — they fail because teams test the wrong things in the wrong order with no clear success criteria. A/B Test Architect gives your AI assistant a complete framework for designing experiments that actually produce learning. Describe what you want to test and get a dev-ready test plan in minutes: structured hypothesis, sample size calculation, recommended duration, segmentation strategy, and guardrail metrics. Built around the Test Velocity Method — a five-step framework for shipping more tests, faster, with better signal. Whether you're running your first A/B test or managing a full experimentation roadmap, this skill keeps your program rigorous from hypothesis to results log.

**Capabilities:**
- Prioritizes test ideas using the PIE scoring matrix (Potential, Importance, Ease) so you always start with the highest-leverage test
- Writes structured hypotheses in the "Because / We believe / Will / For / Measured by" format — forces clarity before a single line of code is written
- Calculates estimated sample size and recommended test duration (always full weeks to account for weekly seasonality)
- Defines primary KPI and guardrail metrics to prevent shipping tests that win on one metric while quietly tanking another
- Guides segmentation decisions — who sees the test, traffic splits, and when to target vs. run full-traffic
- Produces complete dev handoff notes including variant descriptions, analytics instrumentation, QA checklist, and results log format

**Tags:** ab-testing, cro, conversion-rate-optimization, experimentation, marketing
