# 智能选股引擎文档

## 概述

A股量化监控系统内置强大的智能选股引擎，支持短线和中长线两种选股模式，基于多指标共振评分体系，每日自动推荐优质股票。

## 短线选股引擎

### 适用场景
- 持仓周期：1-5天
- 适合：短线交易者、日内波段操作
- 风险等级：中高风险
- 预期收益：5-15%

### 5大短线策略

#### 1. RSI短线策略
**持仓周期**: 1-3天  
**核心逻辑**: 超短线RSI策略，适合T+0或快速进出

**参数**:
- RSI周期: 6
- 超卖阈值: 25
- 超买阈值: 75

**信号**:
- 买入: RSI < 25 且开始回升
- 卖出: RSI > 75 或止盈/止损

#### 2. MACD短线策略
**持仓周期**: 2-5天  
**核心逻辑**: MACD金叉死叉，短期趋势跟踪

**参数**:
- 快线: 8
- 慢线: 17
- 信号线: 9

**信号**:
- 买入: MACD金叉
- 卖出: MACD死叉

#### 3. KDJ短线策略
**持仓周期**: 1-3天  
**核心逻辑**: KDJ超买超卖，适合日内波段

**参数**:
- N值: 9
- 超卖: 20
- 超买: 80

**信号**:
- 买入: KDJ < 20 且K线上穿D线
- 卖出: KDJ > 80 或K线下穿D线

#### 4. 布林突破策略
**持仓周期**: 1-5天  
**核心逻辑**: 布林带突破，捕捉短期波动

**参数**:
- 周期: 10
- 标准差: 1.5

**信号**:
- 买入: 突破下轨后回归
- 卖出: 触及上轨或中轨

#### 5. 放量突破策略
**持仓周期**: 1-3天  
**核心逻辑**: 量价齐升，短期强势股

**参数**:
- 放量倍数: 2.0
- 涨幅阈值: 3%

**信号**:
- 买入: 放量 > 2倍 且 涨幅 > 3%
- 卖出: 缩量或止盈/止损

### 短线评分体系

**满分100分，推荐阈值75分以上**

| 指标 | 权重 | 说明 |
|------|------|------|
| RSI信号 | 20分 | 超卖/超买状态 |
| KDJ信号 | 20分 | 随机指标 |
| MACD信号 | 15分 | 趋势确认 |
| 布林带信号 | 15分 | 波动率突破 |
| 量价异动 | 15分 | 成交量放大 |
| 资金流向 | 15分 | 主力资金净流入 |

### 短线买卖点

**买入价**: 当前价 × (1 + 0.5%)  
**止损价**: 买入价 - 2 × ATR  
**止盈价**: 买入价 + 4 × ATR

**预期收益率**: (止盈价 - 买入价) / 买入价  
**风险收益比**: (止盈价 - 买入价) / (买入价 - 止损价)

### 使用方法

```bash
# 运行短线选股
python3 scripts/short_term_selector.py
```

**输出示例**:
```
========================================
短线选股引擎 - 2026-02-24
========================================

推荐股票: 3 只

1. 长江电力 (600900) - 评分: 85.5
   当前价: ¥26.85
   买入价: ¥27.00 (现价+0.5%)
   止损价: ¥25.80 (2ATR)
   止盈价: ¥29.40 (4ATR)
   预期收益: +8.9%
   风险收益比: 2.0
   
   强项指标:
   ✓ RSI(28.5) 超卖后回升 [20分]
   ✓ KDJ金叉 K(32)>D(28) [18分]
   ✓ MACD柱状图转正 [14分]
   ✓ 放量1.8倍 [12分]
   
   策略: RSI短线 + 放量突破
   持仓周期: 1-3天
```

## 中长线选股引擎

### 适用场景
- 持仓周期：20-180天
- 适合：价值投资者、趋势跟踪者
- 风险等级：中低风险
- 预期收益：15-50%

### 7大中长线策略

#### 1. MA趋势策略
**持仓周期**: 20-60天  
**核心逻辑**: 均线多头排列，趋势跟踪

**参数**:
- 短期均线: MA20
- 长期均线: MA60
- 趋势过滤: MA120

**信号**:
- 买入: MA20 > MA60 > MA120（多头排列）
- 卖出: MA20下穿MA60

#### 2. MACD趋势策略
**持仓周期**: 15-30天  
**核心逻辑**: MACD趋势确认，中期持有

**参数**:
- 快线: 12
- 慢线: 26
- 信号线: 9
- 最少持仓: 15天

**信号**:
- 买入: MACD金叉 且 柱状图连续放大
- 卖出: MACD死叉 或 到达止盈

#### 3. 价值成长策略
**持仓周期**: 60-180天  
**核心逻辑**: 长期价值投资，价值+成长双重验证

**参数**:
- RSI阈值: 40（回调买入）
- MA过滤: MA200
- 最少持仓: 30天

**信号**:
- 买入: 价格回调至MA60 且 RSI < 40
- 卖出: 严重超买或基本面恶化

#### 4. 突破回踩策略
**持仓周期**: 10-30天  
**核心逻辑**: 突破后回踩买入，确认突破有效性

**参数**:
- 突破幅度: 3%
- 回踩幅度: 2%
- 最少持仓: 10天

**信号**:
- 买入: 突破新高后回踩MA20支撑
- 卖出: 跌破MA20或止盈

#### 5. 底部反转策略
**持仓周期**: 15-30天  
**核心逻辑**: RSI+MACD双确认，捕捉底部反转

**参数**:
- RSI阈值: 30
- MACD: 金叉确认

**信号**:
- 买入: RSI < 30 且 MACD金叉
- 卖出: RSI > 70 或止盈

#### 6. 趋势加速策略
**持仓周期**: 10-20天  
**核心逻辑**: 均线多头+放量，趋势加速上涨

**参数**:
- 均线: MA5 > MA10 > MA20
- 放量: 1.5倍

**信号**:
- 买入: 多头排列 + 放量突破
- 卖出: 缩量或破位

#### 7. 强势股回调策略
**持仓周期**: 5-15天  
**核心逻辑**: 强势股回调低吸，追涨强势股

**参数**:
- 近期涨幅: > 20%
- 回调幅度: 5-10%

**信号**:
- 买入: 回调至MA10支撑
- 卖出: 反弹至前高或止损

### 中长线评分体系

**满分100分，推荐阈值70分以上**

| 维度 | 权重 | 子指标 |
|------|------|--------|
| 技术指标 | 40% | MA趋势、MACD、RSI、KDJ |
| 资金流向 | 30% | 主力资金、北向资金 |
| 市场热度 | 15% | 换手率、振幅 |
| 风险评估 | 15% | 波动率、最大回撤 |

### 中长线持仓建议

根据综合评分给出持仓建议：

| 评分 | 建议仓位 | 风险等级 |
|------|----------|----------|
| 90-100 | 80-100% | 低风险 |
| 80-89 | 60-80% | 中低风险 |
| 70-79 | 40-60% | 中等风险 |
| 60-69 | 20-40% | 中高风险 |
| < 60 | 不推荐 | 高风险 |

### 使用方法

```bash
# 运行中长线选股
python3 scripts/long_term_selector.py

# 运行增强版（包含更多维度）
python3 scripts/enhanced_long_term_selector.py
```

**输出示例**:
```
========================================
中长线选股引擎 - 2026-02-24
========================================

推荐股票: 8 只

1. 中国核电 (601985) - 评分: 88.5
   当前价: ¥9.32
   目标价: ¥11.50 (+23.4%)
   止损价: ¥8.80 (-5.6%)
   建议仓位: 70%
   风险等级: 中低风险
   持仓周期: 30-60天
   
   优势:
   ✓ MA20/MA60/MA120多头排列 [35分]
   ✓ MACD金叉且柱状图放大 [32分]
   ✓ 主力资金连续3日净流入 [28分]
   ✓ 波动率低，稳健上涨 [13分]
   
   策略: MA趋势 + MACD趋势
   适合: 稳健型投资者
```

## 自动化选股

### 设置每日选股任务

```bash
# 每日9:30短线选股
openclaw cron add \
  --name "每日短线选股" \
  --schedule "30 9 * * 1-5" \
  --tz "Asia/Shanghai" \
  --session main \
  --payload '{"kind":"systemEvent","text":"cd <skill-path>/scripts && python3 short_term_selector.py"}'

# 每日9:30中长线选股
openclaw cron add \
  --name "每日中长线选股" \
  --schedule "30 9 * * 1-5" \
  --tz "Asia/Shanghai" \
  --session main \
  --payload '{"kind":"systemEvent","text":"cd <skill-path>/scripts && python3 long_term_selector.py"}'
```

## 配置说明

### 自定义股票池

创建 `watchlist.json`：

```json
[
  "600900",
  "601985",
  "600905",
  "000858",
  "600519"
]
```

### 策略参数调整

编辑 `strategy_config.py` 修改策略参数：

```python
SHORT_TERM_STRATEGIES = {
    'rsi_short': {
        'params': {
            'rsi_period': 6,      # 调整RSI周期
            'oversold': 25,       # 调整超卖阈值
        }
    }
}
```

## 风险提示

1. **短线风险**：波动大，需要严格止损
2. **中长线风险**：持仓周期长，需要耐心
3. **策略失效**：市场环境变化可能导致策略失效
4. **仅供参考**：选股结果仅供参考，不构成投资建议

## 最佳实践

1. **组合投资**：短线+中长线组合，分散风险
2. **严格止损**：遵守系统给出的止损价
3. **分批建仓**：不要一次性重仓
4. **跟踪调整**：定期复盘，调整策略参数
5. **控制仓位**：根据评分控制仓位大小

## 常见问题

### Q: 为什么过滤创业板和科创板？
A: 创业板和科创板波动较大，风险较高，不适合通用策略。

### Q: 评分多少才值得买入？
A: 短线建议75分以上，中长线建议70分以上。

### Q: 如何调整策略参数？
A: 编辑 `strategy_config.py`，根据回测结果优化参数。

### Q: 可以同时运行多个策略吗？
A: 可以，系统支持多策略组合，会去重推荐。
