---
name: a-stock-analysis
description: A股实时行情与分时量能分析。获取沪深股票实时价格、涨跌、成交量，分析分时量能分布（早盘/尾盘放量）、主力动向（抢筹/出货信号）、涨停封单。支持持仓管理和盈亏分析。Use when: (1) 查询A股实时行情, (2) 分析主力资金动向, (3) 查看分时成交量分布, (4) 管理股票持仓, (5) 分析持仓盈亏。
---

# A股实时行情与分时量能分析

使用东方财富和新浪财经接口获取A股数据，支持实时行情、分时K线、量能分析。

## 快速开始

### 实时行情

```bash
# 单只股票
uv run {baseDir}/scripts/analyze.py 600789

# 多只股票
uv run {baseDir}/scripts/analyze.py 600789 002446 002342

# 含分时量能分析
uv run {baseDir}/scripts/analyze.py 600789 --minute

# JSON输出
uv run {baseDir}/scripts/analyze.py 600789 --json
```

### 持仓管理

```bash
# 显示持仓
uv run {baseDir}/scripts/portfolio.py show

# 添加持仓
uv run {baseDir}/scripts/portfolio.py add 600789 --cost 10.416 --qty 3400

# 更新持仓
uv run {baseDir}/scripts/portfolio.py update 600789 --cost 10.2

# 删除持仓
uv run {baseDir}/scripts/portfolio.py remove 600789

# 分析所有持仓（含分时量能）
uv run {baseDir}/scripts/portfolio.py analyze
```

## 股票代码格式

直接使用6位数字代码即可，系统自动识别市场：

- **沪市**: 6开头 (如 600789)
- **深市**: 0或3开头 (如 002446, 300001)
- **北交所**: 8或4开头

## 分时量能分析说明

### 成交分布时段

| 时段 | 说明 |
|------|------|
| 早盘30分 (9:30-10:00) | 主力早盘动作，>30%为抢筹信号 |
| 上午中段 (10:00-11:30) | 正常交易 |
| 下午中段 (13:00-14:30) | 正常交易 |
| 尾盘30分 (14:30-15:00) | >25%为尾盘异动信号 |

### 主力动向信号

- **早盘放量 >30%**: 主力早盘抢筹
- **早盘放量 >40%**: 主力强势介入
- **尾盘放量 >15%**: 尾盘有一定放量
- **尾盘放量 >25%**: 可能有主力抢筹或出货
- **封板状态**: 涨停/跌停，关注封单量

### 放量时段 TOP 10

显示当日成交量最大的10个分钟，用于识别：
- 主力建仓/出货时机
- 重大消息发布时点
- 涨停封板/开板时刻

## 数据源

统一使用新浪财经接口，数据一致性好：

| 数据 | 接口 | 延迟 |
|------|------|------|
| 实时行情 | `hq.sinajs.cn` | ~3秒 |
| 分时K线 | `CN_MarketDataService.getKLineData` | ~1分钟 |

支持批量获取，减少请求次数。

## 输出示例

```
============================================================
股票: 鲁抗医药 (600789)
============================================================

【实时行情】
  现价: 10.32  涨跌: +0.88%
  今开: 10.20  最高: 10.77  最低: 9.82
  昨收: 10.23  换手: 2.38%
  成交量: 218.2万手  成交额: 22.51亿

【分时量能分析】鲁抗医药
  全天成交: 2181838手 (225105.3万元)

  成交分布:
    早盘30分(9:30-10:00): 907228手 (41.6%)
    上午中段(10:00-11:30): 866457手 (39.7%)
    下午中段(13:00-14:30): 181321手 (8.3%)
    尾盘30分(14:30-15:00): 225180手 (10.3%)

  放量时段 TOP 10:
    09:31:00 价格:10.03 成交:216545手 金额:21965.3万
    ...

  【主力动向判断】
    🔥 早盘主力抢筹明显
```

## 持仓文件

持仓数据存储在: `~/.clawdbot/skills/a-stock-analysis/portfolio.json`

## 限制

- 仅支持A股（沪深北交所）
- 交易时段外获取的是收盘数据
- 分时数据最多250条（约1个交易日）
