# ✅ 已通过自我审核（v1.0.2）

---
name: 4d-compression-core
version: 1.0.2
description: "把长内容压缩成结构化向量——节省 60-80% Token，保留核心信息"
metadata: { "openclaw": { "emoji": "🌀", "requires": { "bins": ["jq", "awk"] }, "triggers": ["压缩", "4d", "向量", "精简", "compress", "vector"], "priority": "critical" } }
---

# 🌀 4D Compression Core - 4D 向量压缩

> **把长内容压缩成结构化向量——节省 60-80% Token，保留核心信息**

---

## 🎯 核心功能

- 🧠 **结构化压缩** - 四维分离，结构化压缩
- 📊 **智能压缩** - 自动识别核心信息，删除冗余内容
- 🎯 **语义保留** - 保留核心语义，压缩率 60-80%
- 📚 **书籍处理** - EPUB/PDF书籍自动压缩

---

## 🚀 快速开始

**压缩文本**
```
你说："压缩这段内容"

Neo 显示：
🌀 4D 压缩完成

原始：12,345 tokens
压缩后：3,456 tokens
节省：72%

【结构化要点】核心信息...

💡 保留核心语义，可安全使用
```

**处理书籍**
```
你说："处理这本 EPUB"

Neo 显示：
🌀 书籍压缩完成

输入：《重塑心灵》(12 章，500KB)
输出：
  - 压缩版：120KB（节省 76%）
  - 完整版：500KB（原始内容）

💡 压缩版适合快速阅读，完整版适合深度研究
```

---

## 🎯 触发词（随口一说就懂）

| 你想做什么 | 你说 |
|-----------|------|
| 压缩文本 | "压缩"、"4d"、"精简"、"compress" |
| 处理书籍 | "处理 EPUB"、"压缩这本书"、"PDF 压缩" |

**不用配置，说"压缩"就启动。**

---

## 📦 安装

```bash
clawhub install 4d-compression-core
```

---

## ⚠️ 安全与边界

**压缩率**
- 文本：60-80%（因内容而异）
- 书籍：70-80%（实测）

**语义保留**
- 压缩版：保留核心语义
- 完整版：100% 原始内容（备查）

**不过度承诺**
- 压缩率因内容而异
- 诗歌、小说等创意内容压缩率可能较低

---

## 🫂 写在最后

**我们设计这个技能，是因为我们知道：**

长内容费 Token，但你不想丢失核心信息。

你想快速抓住重点，但不想读完全文。

**所以我们做了这个——**

把长内容压缩成结构化向量，节省 60-80% Token。

**不用读全文，核心信息一目了然。**

---

*版本：1.0.1*  
*许可证：MIT*
