---
name: 3d-cog
description: "Other tools need perfect images. CellCog turns ideas into 3D models. From rough sketches, text descriptions, or product photos — production-ready GLB files for games, AR/VR, e-commerce, and 3D printing."
metadata:
  openclaw:
    emoji: "🧊"
author: CellCog
dependencies: [cellcog]
---

# 3D Cog - Turn Ideas Into 3D Models

**Other tools need perfect images. CellCog turns ideas into 3D models.**

Most 3D generation tools need a single, perfectly composed reference image. CellCog takes *anything* — a text description, a rough sketch, a product photo, even a spreadsheet of 50 items — and handles the entire pipeline: reasoning about what you need, generating optimized reference images, and converting them into production-ready GLB files.

---

## Prerequisites

This skill requires the `cellcog` skill for SDK setup and API calls.

```bash
clawhub install cellcog
```

**Read the cellcog skill first** for SDK setup. This skill shows you what's possible.

**Quick pattern (v1.0+):**
```python
# Fire-and-forget - returns immediately
result = client.create_chat(
    prompt="[your 3D generation request]",
    notify_session_key="agent:main:main",
    task_label="3d-gen",
    chat_mode="agent"
)
# Daemon notifies you when complete - do NOT poll
```

---

## What Makes This Different

### Any Input → 3D

The power of CellCog isn't image-to-3D — everyone does that. The power is **any-to-any**.

| What You Send | What CellCog Does | What You Get |
|--------------|-------------------|--------------|
| Text description | Reasons about the object → generates optimized reference image → converts to 3D | Production-ready GLB |
| Rough sketch | Enhances into a clean, detailed reference → converts to 3D | Production-ready GLB |
| Product photo | Assesses quality, enhances if needed → converts to 3D | Production-ready GLB |
| High-quality concept art | Converts directly to 3D | Production-ready GLB |
| List of 10 items | Generates 10 reference images → converts all to 3D | 10 GLB files |

### Batch Generation

Need 10 low-poly weapons for your RPG? 20 furniture models for your room designer? 50 product models for your e-commerce catalog?

One prompt. Multiple 3D models. CellCog's agents generate each reference image with the right composition, angle, and detail level — then convert each to a textured 3D model.

```python
prompt = """
Create 3D models (GLB format) for these 5 fantasy weapons:
1. Enchanted longsword with blue crystal blade
2. Dwarven war hammer with rune inscriptions
3. Elven bow with living vine decorations
4. Shadow dagger with smoke effects on the blade
5. Holy mace with golden sunburst head

Low poly (~10,000 polygons each), game-ready, with PBR materials.
"""
```

---

## What You Can Create

### Game Assets
- **Characters**: Heroes, NPCs, enemies, bosses
- **Weapons**: Swords, bows, staffs, shields, guns
- **Props**: Furniture, treasure chests, potions, tools
- **Vehicles**: Cars, spaceships, boats, mounts
- **Environment pieces**: Trees, rocks, buildings, bridges

### Product Visualization
- **E-commerce 3D viewers**: Let customers rotate and inspect products
- **Product prototypes**: Visualize designs before manufacturing
- **Packaging mockups**: 3D packaging for marketing materials

### AR/VR Objects
- **AR filters and objects**: Place 3D objects in real environments
- **VR environments**: Furnish virtual spaces with custom objects
- **Interactive experiences**: Objects users can inspect and interact with

### 3D Printing
- **Figurines and miniatures**: Tabletop gaming pieces, collectibles
- **Functional objects**: Custom tools, brackets, cases
- **Architectural models**: Building miniatures, terrain pieces

### Education & Training
- **Anatomical models**: Organs, skeletal systems, molecular structures
- **Historical artifacts**: Museum-quality digital replicas
- **Engineering models**: Mechanical parts, assembly visualizations

---

## Output Format

All 3D models are delivered as **GLB files** (binary glTF) — the universal web standard for 3D:
- Supported by Unity, Unreal, Godot, Three.js, Babylon.js
- Works in web browsers via `<model-viewer>` or Three.js
- Compatible with Blender, Maya, 3ds Max for further editing
- Includes textures and materials in a single file

---

## Chat Mode for 3D

| Scenario | Recommended Mode |
|----------|------------------|
| Single 3D object from a clear description or image | `"agent"` |
| Batch generation (5-20 objects from a list) | `"agent"` |
| Complex game asset pipeline with style consistency | `"agent team"` |

**Use `"agent"` for most 3D work.** It handles everything from single objects to batch generation.

**Use `"agent team"` when you need cross-asset consistency** — like generating a full set of fantasy weapons that all share the same art style, or building a complete room of furniture that matches a design language.

---

## Example Prompts

**Single object from description:**
> "Create a 3D model of a steampunk pocket watch with exposed brass gears, an etched glass face, and a chain attachment. GLB format, high detail."

**From a reference image:**
> "Convert this product photo into a 3D model for our online store:
> `<SHOW_FILE>/photos/sneaker_product.png</SHOW_FILE>`
> 
> Output as GLB, enable PBR materials for realistic rendering."

**Batch generation:**
> "Generate 3D models for these 8 pieces of modern furniture:
> 1. Minimalist sofa (3-seater, light gray)
> 2. Round coffee table (walnut wood, glass top)
> 3. Floor lamp (arc style, brass finish)
> 4. Bookshelf (5 tiers, oak wood)
> 5. Dining chair (Scandinavian, white)
> 6. Side table (concrete, cylindrical)
> 7. Desk (standing desk, white with birch legs)
> 8. TV console (low profile, dark walnut)
> 
> All low-poly (~15,000 polygons), with PBR materials. GLB format."

**From a rough sketch:**
> "Here's my rough sketch of a robot character:
> `<SHOW_FILE>/sketches/robot_concept.jpg</SHOW_FILE>`
> 
> Turn this into a polished 3D model. It's a friendly service robot — round body, simple limbs, LED face display. Style: Overwatch/Pixar clean 3D. Output as GLB."

**Game asset set:**
> "I'm building a dungeon crawler. Create 3D models for these dungeon props:
> - Wooden treasure chest (open and closed variants)
> - Iron torch holder with flame
> - Stone altar with carved runes
> - Wooden barrel (intact and broken)
> - Skull pile
> 
> Style: Dark fantasy, hand-painted textures. Low poly for mobile game (~8,000 polygons each)."

---

## Tips for Better 3D Models

1. **Be specific about materials**: "brushed aluminum", "aged leather", "polished marble" — CellCog uses these to generate better reference images and textures.

2. **Specify your target platform**: "low-poly for mobile game" vs "high-detail for cinematic render" changes the approach completely.

3. **Send reference images when possible**: Even imperfect references give CellCog a head start over pure text descriptions.

4. **For batch jobs, describe style once**: "All in a cohesive hand-painted fantasy style" keeps your assets consistent.

5. **Request PBR materials for realism**: If you need metallic, roughness, and normal maps — say so. Essential for game engines and realistic rendering.
