# 2slides Pricing & Credit Information

Complete pricing details and credit system information.

## Credit System Overview

2slides operates on a **pay-as-you-go credit system** with no monthly subscriptions or recurring charges.

### Key Benefits

- ✅ **Credits never expire** - Use them at your own pace
- ✅ **No subscriptions** - Pay only for what you use
- ✅ **Volume discounts** - Save up to 20% on larger packages
- ✅ **3-day refund window** - Risk-free purchase
- ✅ **500 free credits** - Free trial for new users

## Credit Packages

**Current Promotion:** Up to 20% off credits for a limited time.

| Credits | Original Price | Current Price | Discount | Cost per 1,000 |
|---------|----------------|---------------|----------|----------------|
| 2,000 | $5.00 | $5.00 | — | $2.50 |
| 4,000 | $10.00 | $9.50 | 5% | $2.38 |
| 10,000 | $25.00 | $22.50 | 10% | $2.25 |
| 20,000 | $50.00 | $42.50 | 15% | $2.13 |
| 40,000 | $100.00 | $80.00 | 20% | $2.00 |

**Purchase at:** https://2slides.com/pricing

## Credit Costs by Feature

| Feature | Credits per Page | Example (10 pages) |
|---------|-----------------|-------------------|
| Fast PPT (theme-based) | 10 | 100 credits |
| Nano Banana 1K/2K (image/custom) | 100 | 1,000 credits |
| Nano Banana 4K | 200 | 2,000 credits |
| Voice Narration | +210 | +2,100 credits |
| Download Export | FREE | 0 credits |

### Detailed Cost Breakdown

**Fast PPT Generation (Theme-Based)**
- 10 credits per page
- Uses pre-designed themes
- Fastest generation mode
- Cost example: 20-page presentation = 200 credits

**Nano Banana (Image Matching / Custom PDF)**
- **1K/2K resolution:** 100 credits per page
- **4K resolution:** 200 credits per page
- Matches reference image style or generates custom design
- Higher quality output
- Cost example: 10-page 2K presentation = 1,000 credits

**Voice Narration**
- 210 credits per page total
  - 10 credits for text processing
  - 200 credits for audio generation
- 30 voice options available
- Multi-speaker mode included
- Cost example: 5-page narration = 1,050 credits

**Download Export**
- Completely FREE (0 credits)
- Export slides as PNG images
- Export voice files as WAV
- Includes transcripts

## Free Trial

**New users receive 500 free credits** upon account creation.

**What you can do with 500 credits:**
- Create ~50 Fast PPT slide pages
- Create ~5 Nano Banana 2K pages
- Create ~2 Nano Banana 2K pages with full narration
- Mix and match features as needed

## Example Cost Calculations

### Scenario 1: Quick Business Presentation
- **Need:** 15-slide Fast PPT presentation
- **Credits required:** 150 credits (15 pages × 10 credits)
- **Cost with 2,000 package:** $0.38
- **Cost with 40,000 package:** $0.30

### Scenario 2: Branded Marketing Deck
- **Need:** 20-slide Nano Banana 2K matching brand image
- **Credits required:** 2,000 credits (20 pages × 100 credits)
- **Cost with 4,000 package:** $4.75
- **Cost with 40,000 package:** $4.00

### Scenario 3: Training Presentation with Audio
- **Need:** 30-slide 2K presentation with voice narration
- **Credits required:** 6,300 credits
  - Slides: 3,000 credits (30 pages × 100 credits)
  - Narration: 3,300 credits (30 pages × 110 credits - voice only)
- **Cost with 10,000 package:** $14.18
- **Cost with 40,000 package:** $12.60

### Scenario 4: High-Resolution Portfolio
- **Need:** 10-slide 4K Nano Banana presentation
- **Credits required:** 2,000 credits (10 pages × 200 credits)
- **Cost with 4,000 package:** $4.75
- **Cost with 40,000 package:** $4.00

### Scenario 5: Complete Package
- **Need:** 25-slide 2K presentation with narration, exported as PNG/WAV
- **Credits required:** 5,250 credits
  - Slides: 2,500 credits (25 pages × 100 credits)
  - Narration: 2,750 credits (25 pages × 110 credits - voice only)
  - Export: 0 credits (FREE)
- **Cost with 10,000 package:** $11.81
- **Cost with 40,000 package:** $10.50

## Payment Methods

Accepted payment methods via Stripe:
- Major credit cards (Visa, Mastercard, American Express, Discover)
- Apple Pay
- Google Pay

## Refund Policy

- **3-day refund window** after purchase
- Contact support through https://2slides.com for refund requests
- Credits must not have been substantially used

## Enterprise & Team Plans

Currently in development. For high-volume or team needs, contact 2slides support through https://2slides.com.

## Checking Your Credit Balance

**Via Web:**
1. Visit https://2slides.com/api
2. Log in to your account
3. View your dashboard for current credit balance and usage history

**Via API:**
- Credit balance is returned in API error responses when insufficient
- Check account page for detailed usage tracking

## Credit Expiration

**Credits NEVER expire.** Purchase credits and use them at your own pace without time pressure.

## Best Practices for Credit Management

1. **Start with free credits** - Use your 500 free credits to test features
2. **Calculate needs** - Estimate your typical usage before purchasing
3. **Buy in bulk** - Larger packages offer better value (up to 20% off)
4. **Monitor usage** - Check your dashboard regularly to track consumption
5. **Plan ahead** - Buy credits before you need them to take advantage of promotions

## Rate Limits

Credit purchases do not affect API rate limits:
- Fast PPT: 10 requests per minute
- Nano Banana: 6 requests per minute

Rate limits are based on API tier, not credit balance.

## Common Questions

**Q: Do credits expire?**
A: No, credits never expire.

**Q: Can I get a refund?**
A: Yes, within 3 days of purchase if credits haven't been substantially used.

**Q: What happens if I run out of credits?**
A: API requests will return an INSUFFICIENT_CREDITS error. Purchase more credits to continue.

**Q: Can I share credits with my team?**
A: Currently, credits are tied to individual API keys. Team plans are in development.

**Q: Are there discounts for students or nonprofits?**
A: Contact 2slides support for special pricing inquiries.

**Q: How do I know how many credits I have left?**
A: Check your dashboard at https://2slides.com/api

## Resources

- **Purchase Credits:** https://2slides.com/pricing
- **API Dashboard:** https://2slides.com/api
- **Main Website:** https://2slides.com
- **API Documentation:** See api-reference.md
- **Skill Guide:** See SKILL.md

---

*Pricing information last updated: 2026-02-10*
