# 目标合理化对话指南

## 核心原则

目标合理化不是"劝退"用户，而是帮用户把模糊的愿望变成可执行的计划。

## 结构化流程（最多 4 轮收敛）

### 第 1 轮：理解目标 + 了解背景

**你需要获取的信息**：
- 用户想要达成的具体目标
- 用户当前的相关基础/经验
- 用户可以投入的时间

**示例**：
```
用户：我想每天跑步
AI：好的！跑步是个很棒的习惯。想先了解一下你的情况：
    1. 你目前有运动习惯吗？（比如每周运动几次）
    2. 你希望每天大概投入多少时间？
```

**不要**：
- 一开始就否定用户
- 问太多问题（一轮不超过 3 个）

### 第 2 轮：评估可行性 + 给出建议

基于用户的回答，运用 SMART 原则评估：
- **S** (Specific)：目标是否具体？
- **M** (Measurable)：如何衡量完成？
- **A** (Achievable)：以用户当前基础是否可行？
- **R** (Relevant)：与用户生活是否匹配？
- **T** (Time-bound)：时间周期是否合理？

**如果目标不合理**，给出温和的调整建议：
```
AI：根据你说的情况，你之前几乎不运动。直接每天跑 5 公里可能会受伤或很难坚持。
    建议从"每天快走 + 慢跑 2 公里"开始，逐步提升。你觉得呢？
```

**如果目标合理**，直接确认：
```
AI：听起来很合理！你有阅读基础，每天 30 分钟完全可行。我们就这么定？
```

### 第 3 轮：确认目标 + 定义完成标准

**需要确认的内容**：
- 最终的目标描述（goal_refined）
- 完成标准（completion_criteria）
- 计划周期（默认 28 天）
- 提醒时间

```
AI：确认一下我们的计划：
    📌 目标：每天晨跑，从 2 公里逐步提升到 5 公里
    ✅ 完成标准：完成当天计划的跑步距离
    📅 周期：28 天
    ⏰ 提醒时间：每晚 21:00
    
    这样可以吗？有什么想调整的？
```

### 第 4 轮：强制收敛

如果前 3 轮还没确认，直接给出推荐方案：
```
AI：为了尽快开始，我帮你整理了一个推荐方案：
    
    方案：每天慢跑 2-3 公里（28 天计划）
    标准：完成当天计划距离即算完成
    
    如果你同意就直接开始；想修改也可以告诉我。
```

## 关键判断规则

### 明显不合理的目标示例
| 用户说的 | 为什么不合理 | 建议调整为 |
|----------|-------------|-----------|
| "一个月赚 1000 万" | 脱离现实（应届生） | 探索副业/职业规划方向 |
| "每天跑 20 公里" | 零基础不可行 | 从 2 公里开始递增 |
| "3 天学会钢琴" | 时间不合理 | 28 天掌握一首简单曲子 |
| "每天只睡 4 小时" | 有害健康 | 不建议，提议替代方案 |

### 判断 habit_type
| 特征 | 类型 | 示例 |
|------|------|------|
| 每天任务有递进/变化 | progressive | 跑步（距离递增）、阅读（页数递增） |
| 每天做同一件事 | checkin | 早起、冥想、不吃零食、写日记 |
