# 边界场景处理指南

## 1. 并行习惯管理

### 达到上限（5个）
```
用户：我还想加一个冥想的习惯
AI：你当前已经有 5 个在追踪的习惯了，这已经很多了！
    建议先专注完成现有的，或者暂停/放弃一个再添加。
    你当前的习惯有：
    1. 跑步 (Day 12/28)
    2. 阅读 (Day 8/28)
    ...
    要调整哪个吗？
```

### 建议控制数量
即使没达上限，如果用户已有 3 个以上，温和提醒：
```
AI：你已经在追踪 3 个习惯了，建议不要同时追踪太多。
    确定要添加吗？
```

## 2. 时区处理

- 所有日期计算基于 `settings.timezone`
- 默认 `Asia/Shanghai`
- "今天"的判定：用户本地日期
- 首次使用时确认时区：
  ```
  AI：为了准确追踪你的打卡，确认一下你所在的时区是北京时间（Asia/Shanghai）对吗？
  ```

## 3. 数据异常

### JSON 文件损坏
- 自动备份损坏文件到 backups/ 目录
- 返回空数据重新开始
- 告知用户："数据出了点问题，我已经备份了旧数据。需要重新设置习惯。"

### 状态不一致
- 如果 `current_day > total_days` 但 status 还是 active → 触发完成流程
- 如果有 check_in 但没有对应的 phase → 忽略，不报错

## 4. 模糊输入处理

### 不确定指向哪个习惯
```
用户：今天完成了
AI（1个习惯）：跑步完成了对吗？跑了多少公里？
AI（多个习惯）：你说的是哪个习惯？今天你有跑步和阅读两个任务。
```

### 不确定完成程度
```
用户：今天差不多吧
AI：具体来说是：
    1. 完全完成了 ✅
    2. 做了一部分 🟡
    3. 没有做 ❌
```

### 用户发牢骚
```
用户：太累了不想动
AI：理解，每个人都有状态不好的时候。今天的任务是慢跑 3 公里。
    如果觉得强度太大，可以降低一点——哪怕走一走也行。
    或者我们可以调整一下接下来的计划？
```

## 5. 补报规则

### 7 天内可补报
```
用户：前天其实跑了的
AI：好的，我帮你补上 Day 5 的打卡。完成了多少？
```

### 超过 7 天
```
用户：上周二其实做了
AI：抱歉，超过 7 天的无法补报了。不过没关系，从今天开始保持就好！
```

## 6. 特殊状态转换

### Draft → Abandoned（合理化中途放弃）
保留记录，后续可以提醒：
```
AI（下次对话心跳检测到 draft）：你之前想开始一个跑步的计划，还感兴趣吗？
```

### Active → Paused → Active
恢复时检查缺勤天数，自动 backfill：
```
AI：欢迎回来！暂停期间有 X 天没有追踪，已自动标记为缺勤。
    从今天开始继续，当前是 Day Y。
```

### 连续两周期 < 30% → 目标重新评估
```
AI：你的跑步计划连续两个周期完成率都比较低。
    这不一定是你的问题——可能是目标设得太高了。
    我们重新聊聊？也许可以换个更适合当前节奏的目标。
```
