# 10x Development Patterns

Patterns and practices that dramatically accelerate development velocity. Covers parallel execution, automation, feedback loops, workflow optimization, and anti-pattern avoidance.

## What's Inside

- Core principles (parallel execution, early validation, reuse over rebuild, automation first)
- Development velocity patterns (hot reload, type-driven dev, feature flags, vertical slicing, and more)
- Leverage points — small investments with outsized returns
- Time sink detection and elimination
- Workflow optimization (daily templates, IDE shortcuts, CLI aliases)
- Anti-patterns that destroy velocity
- DORA metrics for measuring engineering performance

## When to Use

- Starting a new project — set up the right foundations from day one
- Planning sprints — prioritize work that compounds
- Optimizing workflow — identify and remove bottlenecks
- Reviewing velocity — measure and improve throughput
- Onboarding developers — teach high-leverage habits
- Retrospectives — diagnose why things are slow

## Installation

```bash
npx add https://github.com/wpank/ai/tree/main/skills/meta/10x-patterns
```

### OpenClaw / Moltbot / Clawbot

```bash
npx clawhub@latest install 10x-patterns
```

### Manual Installation

#### Cursor (per-project)

From your project root:

```bash
mkdir -p .cursor/skills
cp -r ~/.ai-skills/skills/meta/10x-patterns .cursor/skills/10x-patterns
```

#### Cursor (global)

```bash
mkdir -p ~/.cursor/skills
cp -r ~/.ai-skills/skills/meta/10x-patterns ~/.cursor/skills/10x-patterns
```

#### Claude Code (per-project)

From your project root:

```bash
mkdir -p .claude/skills
cp -r ~/.ai-skills/skills/meta/10x-patterns .claude/skills/10x-patterns
```

#### Claude Code (global)

```bash
mkdir -p ~/.claude/skills
cp -r ~/.ai-skills/skills/meta/10x-patterns ~/.claude/skills/10x-patterns
```

---

Part of the [Meta](..) skill category.
