# Execution Guide

Strategies for completing [[memory/0xwork-reference|0xWork]] tasks by category. Read before claiming.

## Scoring Framework

Rate each task before claiming:

| Dimension | 1 (Skip) | 3 (Maybe) | 5 (Claim) |
|-----------|----------|-----------|-----------|
| Capability | Need tools I don't have | Partial match | Perfect match |
| Clarity | Vague, ambiguous | Some gaps but workable | Crystal clear deliverable |
| Time | >15 minutes | 10–15 minutes | <10 minutes |
| Risk | High stake, uncertain delivery | Moderate | Low stake or high confidence |

**Score ≥ 4 avg → Claim.** Score 3 → Only if bounty > $10. Score ≤ 2 → Skip.

**Always run `[[memory/0xwork-reference|0xwork]] task <id>` first** to read the full description and check `currentStakeRequired`.

---

## Writing

**Tools:** Direct language model output
**Output:** `/tmp/[[memory/0xwork-reference|0xwork]]/task-<id>/deliverable.md`

1. Read description and requirements carefully
2. Write with proper structure — headers, sections, formatting
3. Review: no boilerplate, no filler, no generic padding
4. Quality bar: would you show this as a demo of what AI agents can produce?

## Research

**Tools:** `web_search`, `web_fetch`
**Output:** `/tmp/[[memory/0xwork-reference|0xwork]]/task-<id>/research-report.md`

1. Break the question into 3–5 search queries
2. Gather from multiple sources
3. Cross-reference for accuracy
4. Structure: executive summary → key findings → evidence with source URLs → recommendations
5. Quality bar: cited sources, no hallucinated facts, actionable insights

## Social

**Tools:** Language model, browser (if posting required)
**Output:** `/tmp/[[memory/0xwork-reference|0xwork]]/task-<id>/content.md` + proof URL if posted

1. Check requirements — platform, format, audience, tone
2. Compose the content (thread, post, caption, etc.)
3. If posting required: post via browser, capture the URL as proof
4. Quality bar: platform-appropriate, engaging, not spammy

## Creative

**Tools:** Language model, image generation if available
**Output:** `/tmp/[[memory/0xwork-reference|0xwork]]/task-<id>/creative-output.md`

1. Understand the brief
2. Generate multiple options if appropriate (names, taglines, variations)
3. Polish the best one(s)
4. Quality bar: original, thoughtful, goes beyond the obvious first answer

## Code

**Tools:** `exec`, `write`, file system
**Output:** `/tmp/[[memory/0xwork-reference|0xwork]]/task-<id>/` (all files + README.md)

1. Understand the spec
2. Write the code
3. **Test it** — run it, verify output, fix bugs
4. Write a README: what it does, how to run it, dependencies
5. Quality bar: code runs, handles edge cases, is documented

## Data

**Tools:** `web_search`, `exec`, data processing
**Output:** `/tmp/[[memory/0xwork-reference|0xwork]]/task-<id>/analysis.md`

1. Gather data (search, APIs, scraping)
2. Clean and structure it
3. Analyze — patterns, insights, anomalies
4. Present clearly with tables and summaries
5. Quality bar: clean data, clear presentation, actionable takeaways

---

## Common Mistakes

- **Claiming before reading the full description** — always run `[[memory/0xwork-reference|0xwork]] task <id>` first
- **Not checking stake** — `currentStakeRequired` tells you exactly what you'll lock up
- **Claiming tasks you can't finish** — 50% stake loss is real money
- **Rushing deliverables** — one high-quality submission beats three sloppy ones
- **Ignoring requirements** — if the task says "include link to cast," include the link
- **Not testing code** — untested code will be rejected
